Imports Microsoft.VisualBasic

Public Class Config
    ''' <summary>
    ''' Waciwo acucha poczenia, wycignitego z web.config
    ''' </summary>
    Public Shared ReadOnly Property ConnectionString() As String
        Get
            Return ConfigurationManager.ConnectionStrings("ConnectionString").ConnectionString
        End Get
    End Property
    ''' <summary>
    ''' Biecy motyw witryny zdefiniowany w pliku web.config
    ''' </summary>
    Public Shared ReadOnly Property CurrentTheme() As String
        Get
            Return ConfigurationManager.AppSettings("CurrentTheme").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Tytu kadej strony HTML, zdefiniowany w pliku web.config
    ''' </summary>
    Public Shared ReadOnly Property PageTitle() As String
        Get
            Return ConfigurationManager.AppSettings("PageTitle").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Fizyczna cieka dostpu do folderu lokalnego, przechowujcego pliki wysyane na serwer
    ''' zdefiniowana w pliku web.config 
    ''' </summary>
    Public Shared ReadOnly Property ShareLocalFolderPath() As String
        Get
            Return ConfigurationManager.AppSettings("ShareLocalFolderPath").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Tytu wszystkich wychodzcych e-maili powiadamiajcych uytkownikw, e przesano im plik do pobrania...
    ''' </summary>
    Public Shared ReadOnly Property EmailSubject() As String
        Get
            Return ConfigurationManager.AppSettings("EmailSubject").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Administracyjne konto poczty do wysyania e-maili 
    ''' </summary>
    Public Shared ReadOnly Property EmailFrom() As String
        Get
            Return ConfigurationManager.AppSettings("EmailFrom").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Wpis konfiguracji okrelajcy, czy tre wiadomoci jest kodem HTML czy zwykym tekstem...
    ''' </summary>
    Public Shared ReadOnly Property EmailFormatSelected() As String
        Get
            Return ConfigurationManager.AppSettings("EmailFormatSelected").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Wpis konfiguracji okrelajcy nazw / adres serwera SMTP ...
    ''' </summary>
    Public Shared ReadOnly Property SmtpServer() As String
        Get
            Return ConfigurationManager.AppSettings("SmtpServer").ToString()
        End Get
    End Property
    ''' <summary>
    ''' Wpis konfiguracji okrelajcy warto httpDownloadPath...
    ''' domyln wartoci lokaln jest: "http://localhost/FileShare/", jak okrelono w web.config
    ''' </summary>
    Public Shared ReadOnly Property httpDownloadPath() As String
        Get
            Return ConfigurationManager.AppSettings("httpDownloadPath").ToString()
        End Get
    End Property

End Class
